/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj.rendimientos;

import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.ObjetoModeloSucesorValidableAnotado;
import ec.gob.sri.dimm.api.modelo.persistencia.Importable;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionEditable;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import java.util.Map;
import javax.validation.constraints.Pattern;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Cuenta
extends ObjetoModeloSucesorValidableAnotado<ObjetoModelo>
implements InformacionEditable<Cuenta>,
Importable {
    private static final long serialVersionUID = 7536124187741548378L;
    public static final String C_TOTAL_DEPOSITO = "totalDeposito";
    public static final String C_RENDIMIENTO_GENERADO = "rendimientoGenerado";
    private static final String M_REND_GEN = "Rendimiento Generado";
    private static final String VALOR = "El valor ";
    @Pattern(regexp="^((0{1})|(([1-9]{1}))([0-9]{0,11}))(\\.[0-9]{2})?$", message="El valor Total Dep\u00f3sito debe ser 12 enteros y 2 decimales. ")
    private String totalDeposito = "0.00";
    @Pattern(regexp="^((0{1})|(([1-9]{1}))([0-9]{0,11}))(\\.[0-9]{2})?$", message="El valor Rendimiento Generado debe ser 12 enteros y 2 decimales. ")
    private String rendimientoGenerado = "0.00";

    protected ResultadoValidacion validarObjeto() {
        ResultadoValidacion resultado = new ResultadoValidacion();
        return resultado;
    }

    public Cuenta crearCopiaEdicion() {
        Cuenta copia = new Cuenta();
        copia.setTotalDeposito(this.totalDeposito);
        copia.setRendimientoGenerado(this.rendimientoGenerado);
        copia.setPropietario(this.propietario);
        return copia;
    }

    public void reiniciar() {
        this.setTotalDeposito("0.00");
        this.setRendimientoGenerado("0.00");
    }

    public void actualizarInformacion(Cuenta copiaEdicion) {
        this.setTotalDeposito(copiaEdicion.getTotalDeposito());
        this.setRendimientoGenerado(copiaEdicion.getRendimientoGenerado());
    }

    public Object importar(Element elemento, Map<String, Element> mapaData) {
        NodeList valorList = elemento.getElementsByTagName("totalDep");
        Element eValor = (Element)valorList.item(0);
        this.totalDeposito = eValor.getTextContent().trim();
        valorList = elemento.getElementsByTagName("rendGen");
        eValor = (Element)valorList.item(0);
        this.rendimientoGenerado = eValor.getTextContent().trim();
        return this;
    }

    public String getTotalDeposito() {
        return this.totalDeposito;
    }

    public String getRendimientoGenerado() {
        return this.rendimientoGenerado;
    }

    public void setTotalDeposito(String totalDeposito) {
        String oldValue = this.totalDeposito;
        this.totalDeposito = totalDeposito;
        this.firePropertyChange(C_TOTAL_DEPOSITO, oldValue, this.totalDeposito);
    }

    public void setRendimientoGenerado(String rendimientoGenerado) {
        String oldValue = this.rendimientoGenerado;
        this.rendimientoGenerado = rendimientoGenerado;
        this.firePropertyChange(C_RENDIMIENTO_GENERADO, oldValue, this.rendimientoGenerado);
    }
}

